package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetImageBlockPublicAccessStateResponse(
    imageBlockPublicAccessState: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateResponse = {
    import GetImageBlockPublicAccessStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateResponse
      .builder()
      .optionallyWith(
        imageBlockPublicAccessState.map(value => value: java.lang.String)
      )(_.imageBlockPublicAccessState)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetImageBlockPublicAccessStateResponse.ReadOnly =
    zio.aws.ec2.model.GetImageBlockPublicAccessStateResponse
      .wrap(buildAwsValue())
}
object GetImageBlockPublicAccessStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetImageBlockPublicAccessStateResponse =
      zio.aws.ec2.model.GetImageBlockPublicAccessStateResponse(
        imageBlockPublicAccessState.map(value => value)
      )
    def imageBlockPublicAccessState: Optional[String]
    def getImageBlockPublicAccessState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "imageBlockPublicAccessState",
        imageBlockPublicAccessState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateResponse
  ) extends zio.aws.ec2.model.GetImageBlockPublicAccessStateResponse.ReadOnly {
    override val imageBlockPublicAccessState: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBlockPublicAccessState())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateResponse
  ): zio.aws.ec2.model.GetImageBlockPublicAccessStateResponse.ReadOnly =
    new Wrapper(impl)
}
