package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnclaveOptions(enabled: Optional[Boolean] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnclaveOptions = {
    import EnclaveOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnclaveOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnclaveOptions.ReadOnly =
    zio.aws.ec2.model.EnclaveOptions.wrap(buildAwsValue())
}
object EnclaveOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnclaveOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnclaveOptions =
      zio.aws.ec2.model.EnclaveOptions(enabled.map(value => value))
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnclaveOptions
  ) extends zio.aws.ec2.model.EnclaveOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnclaveOptions
  ): zio.aws.ec2.model.EnclaveOptions.ReadOnly = new Wrapper(impl)
}
