package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableImageBlockPublicAccessRequest(
    imageBlockPublicAccessState: zio.aws.ec2.model.ImageBlockPublicAccessEnabledState,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessRequest = {
    import EnableImageBlockPublicAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessRequest
      .builder()
      .imageBlockPublicAccessState(imageBlockPublicAccessState.unwrap)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableImageBlockPublicAccessRequest.ReadOnly =
    zio.aws.ec2.model.EnableImageBlockPublicAccessRequest.wrap(buildAwsValue())
}
object EnableImageBlockPublicAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableImageBlockPublicAccessRequest =
      zio.aws.ec2.model.EnableImageBlockPublicAccessRequest(
        imageBlockPublicAccessState,
        dryRun.map(value => value)
      )
    def imageBlockPublicAccessState
        : zio.aws.ec2.model.ImageBlockPublicAccessEnabledState
    def dryRun: Optional[Boolean]
    def getImageBlockPublicAccessState: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.ImageBlockPublicAccessEnabledState
    ] = ZIO.succeed(imageBlockPublicAccessState)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessRequest
  ) extends zio.aws.ec2.model.EnableImageBlockPublicAccessRequest.ReadOnly {
    override val imageBlockPublicAccessState
        : zio.aws.ec2.model.ImageBlockPublicAccessEnabledState =
      zio.aws.ec2.model.ImageBlockPublicAccessEnabledState
        .wrap(impl.imageBlockPublicAccessState())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessRequest
  ): zio.aws.ec2.model.EnableImageBlockPublicAccessRequest.ReadOnly =
    new Wrapper(impl)
}
