package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DeviceTrustProviderType {
  def unwrap: software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType
}
object DeviceTrustProviderType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType
  ): zio.aws.ec2.model.DeviceTrustProviderType = value match {
    case software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType.JAMF =>
      val r = jamf
      r
    case software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType.CROWDSTRIKE =>
      val r = crowdstrike
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.DeviceTrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType =
      software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object jamf extends zio.aws.ec2.model.DeviceTrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType =
      software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType.JAMF
  }
  case object crowdstrike extends zio.aws.ec2.model.DeviceTrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType =
      software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType.CROWDSTRIKE
  }
}
