package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, InternetGatewayId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetachInternetGatewayRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    internetGatewayId: InternetGatewayId,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest = {
    import DetachInternetGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .internetGatewayId(
        InternetGatewayId.unwrap(internetGatewayId): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DetachInternetGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DetachInternetGatewayRequest.wrap(buildAwsValue())
}
object DetachInternetGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DetachInternetGatewayRequest =
      zio.aws.ec2.model.DetachInternetGatewayRequest(
        dryRun.map(value => value),
        internetGatewayId,
        vpcId
      )
    def dryRun: Optional[Boolean]
    def internetGatewayId: InternetGatewayId
    def vpcId: VpcId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInternetGatewayId: ZIO[Any, Nothing, InternetGatewayId] =
      ZIO.succeed(internetGatewayId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest
  ) extends zio.aws.ec2.model.DetachInternetGatewayRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val internetGatewayId: InternetGatewayId =
      zio.aws.ec2.model.primitives.InternetGatewayId(impl.internetGatewayId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest
  ): zio.aws.ec2.model.DetachInternetGatewayRequest.ReadOnly = new Wrapper(impl)
}
