package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcAttributeRequest(
    attribute: zio.aws.ec2.model.VpcAttributeName,
    vpcId: VpcId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest = {
    import DescribeVpcAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcAttributeRequest.wrap(buildAwsValue())
}
object DescribeVpcAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcAttributeRequest =
      zio.aws.ec2.model.DescribeVpcAttributeRequest(
        attribute,
        vpcId,
        dryRun.map(value => value)
      )
    def attribute: zio.aws.ec2.model.VpcAttributeName
    def vpcId: VpcId
    def dryRun: Optional[Boolean]
    def getAttribute: ZIO[Any, Nothing, zio.aws.ec2.model.VpcAttributeName] =
      ZIO.succeed(attribute)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest
  ) extends zio.aws.ec2.model.DescribeVpcAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.VpcAttributeName =
      zio.aws.ec2.model.VpcAttributeName.wrap(impl.attribute())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest
  ): zio.aws.ec2.model.DescribeVpcAttributeRequest.ReadOnly = new Wrapper(impl)
}
