package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeVerifiedAccessTrustProvidersMaxResults,
  VerifiedAccessTrustProviderId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessTrustProvidersRequest(
    verifiedAccessTrustProviderIds: Optional[
      Iterable[VerifiedAccessTrustProviderId]
    ] = Optional.Absent,
    maxResults: Optional[DescribeVerifiedAccessTrustProvidersMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest = {
    import DescribeVerifiedAccessTrustProvidersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest
      .builder()
      .optionallyWith(
        verifiedAccessTrustProviderIds.map(value =>
          value.map { item =>
            VerifiedAccessTrustProviderId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.verifiedAccessTrustProviderIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeVerifiedAccessTrustProvidersMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersRequest
      .wrap(buildAwsValue())
}
object DescribeVerifiedAccessTrustProvidersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersRequest =
      zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersRequest(
        verifiedAccessTrustProviderIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def verifiedAccessTrustProviderIds
        : Optional[List[VerifiedAccessTrustProviderId]]
    def maxResults: Optional[DescribeVerifiedAccessTrustProvidersMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getVerifiedAccessTrustProviderIds
        : ZIO[Any, AwsError, List[VerifiedAccessTrustProviderId]] =
      AwsError.unwrapOptionField(
        "verifiedAccessTrustProviderIds",
        verifiedAccessTrustProviderIds
      )
    def getMaxResults
        : ZIO[Any, AwsError, DescribeVerifiedAccessTrustProvidersMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersRequest.ReadOnly {
    override val verifiedAccessTrustProviderIds
        : Optional[List[VerifiedAccessTrustProviderId]] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAccessTrustProviderIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VerifiedAccessTrustProviderId(item)
        }.toList
      )
    override val maxResults
        : Optional[DescribeVerifiedAccessTrustProvidersMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeVerifiedAccessTrustProvidersMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest
  ): zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersRequest.ReadOnly =
    new Wrapper(impl)
}
