package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DateTime,
  SpotFleetRequestId,
  DescribeSpotFleetRequestHistoryMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetRequestHistoryRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    eventType: Optional[zio.aws.ec2.model.EventType] = Optional.Absent,
    maxResults: Optional[DescribeSpotFleetRequestHistoryMaxResults] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    spotFleetRequestId: SpotFleetRequestId,
    startTime: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest = {
    import DescribeSpotFleetRequestHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(
        maxResults.map(value =>
          DescribeSpotFleetRequestHistoryMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .spotFleetRequestId(
        SpotFleetRequestId.unwrap(spotFleetRequestId): java.lang.String
      )
      .startTime(DateTime.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest
      .wrap(buildAwsValue())
}
object DescribeSpotFleetRequestHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest =
      zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest(
        dryRun.map(value => value),
        eventType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        spotFleetRequestId,
        startTime
      )
    def dryRun: Optional[Boolean]
    def eventType: Optional[zio.aws.ec2.model.EventType]
    def maxResults: Optional[DescribeSpotFleetRequestHistoryMaxResults]
    def nextToken: Optional[String]
    def spotFleetRequestId: SpotFleetRequestId
    def startTime: DateTime
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEventType: ZIO[Any, AwsError, zio.aws.ec2.model.EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeSpotFleetRequestHistoryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestId: ZIO[Any, Nothing, SpotFleetRequestId] =
      ZIO.succeed(spotFleetRequestId)
    def getStartTime: ZIO[Any, Nothing, DateTime] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ) extends zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val eventType: Optional[zio.aws.ec2.model.EventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventType())
        .map(value => zio.aws.ec2.model.EventType.wrap(value))
    override val maxResults
        : Optional[DescribeSpotFleetRequestHistoryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeSpotFleetRequestHistoryMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val spotFleetRequestId: SpotFleetRequestId =
      zio.aws.ec2.model.primitives.SpotFleetRequestId(impl.spotFleetRequestId())
    override val startTime: DateTime =
      zio.aws.ec2.model.primitives.DateTime(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ): zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
