package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    ownerIds: Optional[Iterable[String]] = Optional.Absent,
    restorableByUserIds: Optional[Iterable[String]] = Optional.Absent,
    snapshotIds: Optional[Iterable[SnapshotId]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest = {
    import DescribeSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        ownerIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ownerIds)
      .optionallyWith(
        restorableByUserIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.restorableByUserIds)
      .optionallyWith(
        snapshotIds.map(value =>
          value.map { item =>
            SnapshotId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotIds)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSnapshotsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSnapshotsRequest =
      zio.aws.ec2.model.DescribeSnapshotsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        ownerIds.map(value => value),
        restorableByUserIds.map(value => value),
        snapshotIds.map(value => value),
        dryRun.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def ownerIds: Optional[List[String]]
    def restorableByUserIds: Optional[List[String]]
    def snapshotIds: Optional[List[SnapshotId]]
    def dryRun: Optional[Boolean]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwnerIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ownerIds", ownerIds)
    def getRestorableByUserIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("restorableByUserIds", restorableByUserIds)
    def getSnapshotIds: ZIO[Any, AwsError, List[SnapshotId]] =
      AwsError.unwrapOptionField("snapshotIds", snapshotIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest
  ) extends zio.aws.ec2.model.DescribeSnapshotsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val ownerIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val restorableByUserIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restorableByUserIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val snapshotIds: Optional[List[SnapshotId]] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SnapshotId(item)
        }.toList
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest
  ): zio.aws.ec2.model.DescribeSnapshotsRequest.ReadOnly = new Wrapper(impl)
}
