package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeScheduledInstanceAvailabilityResponse(
    nextToken: Optional[String] = Optional.Absent,
    scheduledInstanceAvailabilitySet: Optional[
      Iterable[zio.aws.ec2.model.ScheduledInstanceAvailability]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse = {
    import DescribeScheduledInstanceAvailabilityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        scheduledInstanceAvailabilitySet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledInstanceAvailabilitySet)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.ReadOnly =
    zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse
      .wrap(buildAwsValue())
}
object DescribeScheduledInstanceAvailabilityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse =
      zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse(
        nextToken.map(value => value),
        scheduledInstanceAvailabilitySet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def scheduledInstanceAvailabilitySet: Optional[
      List[zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScheduledInstanceAvailabilitySet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "scheduledInstanceAvailabilitySet",
      scheduledInstanceAvailabilitySet
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse
  ) extends zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val scheduledInstanceAvailabilitySet: Optional[
      List[zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledInstanceAvailabilitySet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ScheduledInstanceAvailability.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse
  ): zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.ReadOnly =
    new Wrapper(impl)
}
