package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  NetworkInsightsMaxResults,
  NetworkInsightsPathId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsPathsRequest(
    networkInsightsPathIds: Optional[Iterable[NetworkInsightsPathId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[NetworkInsightsMaxResults] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest = {
    import DescribeNetworkInsightsPathsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest
      .builder()
      .optionallyWith(
        networkInsightsPathIds.map(value =>
          value.map { item =>
            NetworkInsightsPathId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInsightsPathIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          NetworkInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest.wrap(buildAwsValue())
}
object DescribeNetworkInsightsPathsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest =
      zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest(
        networkInsightsPathIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        dryRun.map(value => value),
        nextToken.map(value => value)
      )
    def networkInsightsPathIds: Optional[List[NetworkInsightsPathId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[NetworkInsightsMaxResults]
    def dryRun: Optional[Boolean]
    def nextToken: Optional[NextToken]
    def getNetworkInsightsPathIds
        : ZIO[Any, AwsError, List[NetworkInsightsPathId]] = AwsError
      .unwrapOptionField("networkInsightsPathIds", networkInsightsPathIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, NetworkInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest.ReadOnly {
    override val networkInsightsPathIds: Optional[List[NetworkInsightsPathId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsPathIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.NetworkInsightsPathId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[NetworkInsightsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.NetworkInsightsMaxResults(value)
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest
  ): zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest.ReadOnly =
    new Wrapper(impl)
}
