package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeLaunchTemplatesMaxResults,
  LaunchTemplateName,
  LaunchTemplateId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeLaunchTemplatesRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    launchTemplateIds: Optional[Iterable[LaunchTemplateId]] = Optional.Absent,
    launchTemplateNames: Optional[Iterable[LaunchTemplateName]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeLaunchTemplatesMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest = {
    import DescribeLaunchTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        launchTemplateIds.map(value =>
          value.map { item =>
            LaunchTemplateId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.launchTemplateIds)
      .optionallyWith(
        launchTemplateNames.map(value =>
          value.map { item =>
            LaunchTemplateName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.launchTemplateNames)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeLaunchTemplatesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeLaunchTemplatesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLaunchTemplatesRequest.wrap(buildAwsValue())
}
object DescribeLaunchTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLaunchTemplatesRequest =
      zio.aws.ec2.model.DescribeLaunchTemplatesRequest(
        dryRun.map(value => value),
        launchTemplateIds.map(value => value),
        launchTemplateNames.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def launchTemplateIds: Optional[List[LaunchTemplateId]]
    def launchTemplateNames: Optional[List[LaunchTemplateName]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeLaunchTemplatesMaxResults]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getLaunchTemplateIds: ZIO[Any, AwsError, List[LaunchTemplateId]] =
      AwsError.unwrapOptionField("launchTemplateIds", launchTemplateIds)
    def getLaunchTemplateNames: ZIO[Any, AwsError, List[LaunchTemplateName]] =
      AwsError.unwrapOptionField("launchTemplateNames", launchTemplateNames)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeLaunchTemplatesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest
  ) extends zio.aws.ec2.model.DescribeLaunchTemplatesRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val launchTemplateIds: Optional[List[LaunchTemplateId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.LaunchTemplateId(item)
          }.toList
        )
    override val launchTemplateNames: Optional[List[LaunchTemplateName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.LaunchTemplateName(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[DescribeLaunchTemplatesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeLaunchTemplatesMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest
  ): zio.aws.ec2.model.DescribeLaunchTemplatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
