package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceStatusResponse(
    instanceStatuses: Optional[Iterable[zio.aws.ec2.model.InstanceStatus]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse = {
    import DescribeInstanceStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse
      .builder()
      .optionallyWith(
        instanceStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceStatusResponse.wrap(buildAwsValue())
}
object DescribeInstanceStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceStatusResponse =
      zio.aws.ec2.model.DescribeInstanceStatusResponse(
        instanceStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceStatuses
        : Optional[List[zio.aws.ec2.model.InstanceStatus.ReadOnly]]
    def nextToken: Optional[String]
    def getInstanceStatuses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceStatus.ReadOnly]] =
      AwsError.unwrapOptionField("instanceStatuses", instanceStatuses)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse
  ) extends zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly {
    override val instanceStatuses
        : Optional[List[zio.aws.ec2.model.InstanceStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceStatus.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse
  ): zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
