package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceAttributeResponse(
    groups: Optional[Iterable[zio.aws.ec2.model.GroupIdentifier]] =
      Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.InstanceBlockDeviceMapping]
    ] = Optional.Absent,
    disableApiTermination: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    enaSupport: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    enclaveOptions: Optional[zio.aws.ec2.model.EnclaveOptions] =
      Optional.Absent,
    ebsOptimized: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    instanceInitiatedShutdownBehavior: Optional[
      zio.aws.ec2.model.AttributeValue
    ] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    kernelId: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    productCodes: Optional[Iterable[zio.aws.ec2.model.ProductCode]] =
      Optional.Absent,
    ramdiskId: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    rootDeviceName: Optional[zio.aws.ec2.model.AttributeValue] =
      Optional.Absent,
    sourceDestCheck: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    sriovNetSupport: Optional[zio.aws.ec2.model.AttributeValue] =
      Optional.Absent,
    userData: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    disableApiStop: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse = {
    import DescribeInstanceAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        disableApiTermination.map(value => value.buildAwsValue())
      )(_.disableApiTermination)
      .optionallyWith(enaSupport.map(value => value.buildAwsValue()))(
        _.enaSupport
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(ebsOptimized.map(value => value.buildAwsValue()))(
        _.ebsOptimized
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.buildAwsValue())
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(instanceType.map(value => value.buildAwsValue()))(
        _.instanceType
      )
      .optionallyWith(kernelId.map(value => value.buildAwsValue()))(_.kernelId)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(ramdiskId.map(value => value.buildAwsValue()))(
        _.ramdiskId
      )
      .optionallyWith(rootDeviceName.map(value => value.buildAwsValue()))(
        _.rootDeviceName
      )
      .optionallyWith(sourceDestCheck.map(value => value.buildAwsValue()))(
        _.sourceDestCheck
      )
      .optionallyWith(sriovNetSupport.map(value => value.buildAwsValue()))(
        _.sriovNetSupport
      )
      .optionallyWith(userData.map(value => value.buildAwsValue()))(_.userData)
      .optionallyWith(disableApiStop.map(value => value.buildAwsValue()))(
        _.disableApiStop
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceAttributeResponse.wrap(buildAwsValue())
}
object DescribeInstanceAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceAttributeResponse =
      zio.aws.ec2.model.DescribeInstanceAttributeResponse(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableApiTermination.map(value => value.asEditable),
        enaSupport.map(value => value.asEditable),
        enclaveOptions.map(value => value.asEditable),
        ebsOptimized.map(value => value.asEditable),
        instanceId.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value.asEditable),
        instanceType.map(value => value.asEditable),
        kernelId.map(value => value.asEditable),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ramdiskId.map(value => value.asEditable),
        rootDeviceName.map(value => value.asEditable),
        sourceDestCheck.map(value => value.asEditable),
        sriovNetSupport.map(value => value.asEditable),
        userData.map(value => value.asEditable),
        disableApiStop.map(value => value.asEditable)
      )
    def groups: Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly]]
    def disableApiTermination
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enaSupport: Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enclaveOptions: Optional[zio.aws.ec2.model.EnclaveOptions.ReadOnly]
    def ebsOptimized: Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def instanceId: Optional[String]
    def instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def instanceType: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def kernelId: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def productCodes: Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def ramdiskId: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def rootDeviceName: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def sourceDestCheck
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def sriovNetSupport: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def userData: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def disableApiStop
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDisableApiTermination
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getEnaSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getEnclaveOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.EnclaveOptions.ReadOnly] =
      AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getEbsOptimized
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getRamdiskId
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getRootDeviceName
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("rootDeviceName", rootDeviceName)
    def getSourceDestCheck
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getSriovNetSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getUserData
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("userData", userData)
    def getDisableApiStop
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("disableApiStop", disableApiStop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse
  ) extends zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly {
    override val groups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.GroupIdentifier.wrap(item)
          }.toList
        )
    override val blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val disableApiTermination
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableApiTermination())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enaSupport
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enaSupport())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enclaveOptions
        : Optional[zio.aws.ec2.model.EnclaveOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enclaveOptions())
        .map(value => zio.aws.ec2.model.EnclaveOptions.wrap(value))
    override val ebsOptimized
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptimized())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInitiatedShutdownBehavior())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val instanceType
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val kernelId: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kernelId())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val productCodes
        : Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ProductCode.wrap(item)
          }.toList
        )
    override val ramdiskId
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ramdiskId())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val rootDeviceName
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootDeviceName())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val sourceDestCheck
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDestCheck())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val sriovNetSupport
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sriovNetSupport())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val userData: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userData())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val disableApiStop
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableApiStop())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse
  ): zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
