package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeEgressOnlyInternetGatewaysMaxResults,
  EgressOnlyInternetGatewayId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEgressOnlyInternetGatewaysRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    egressOnlyInternetGatewayIds: Optional[
      Iterable[EgressOnlyInternetGatewayId]
    ] = Optional.Absent,
    maxResults: Optional[DescribeEgressOnlyInternetGatewaysMaxResults] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest = {
    import DescribeEgressOnlyInternetGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        egressOnlyInternetGatewayIds.map(value =>
          value.map { item =>
            EgressOnlyInternetGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.egressOnlyInternetGatewayIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeEgressOnlyInternetGatewaysMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
      .wrap(buildAwsValue())
}
object DescribeEgressOnlyInternetGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest =
      zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest(
        dryRun.map(value => value),
        egressOnlyInternetGatewayIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dryRun: Optional[Boolean]
    def egressOnlyInternetGatewayIds
        : Optional[List[EgressOnlyInternetGatewayId]]
    def maxResults: Optional[DescribeEgressOnlyInternetGatewaysMaxResults]
    def nextToken: Optional[String]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEgressOnlyInternetGatewayIds
        : ZIO[Any, AwsError, List[EgressOnlyInternetGatewayId]] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayIds",
        egressOnlyInternetGatewayIds
      )
    def getMaxResults
        : ZIO[Any, AwsError, DescribeEgressOnlyInternetGatewaysMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val egressOnlyInternetGatewayIds
        : Optional[List[EgressOnlyInternetGatewayId]] = zio.aws.core.internal
      .optionalFromNullable(impl.egressOnlyInternetGatewayIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId(item)
        }.toList
      )
    override val maxResults
        : Optional[DescribeEgressOnlyInternetGatewaysMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeEgressOnlyInternetGatewaysMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ): zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest.ReadOnly =
    new Wrapper(impl)
}
