package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeCapacityReservationsMaxResults,
  CapacityReservationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeCapacityReservationsRequest(
    capacityReservationIds: Optional[Iterable[CapacityReservationId]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeCapacityReservationsMaxResults] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest = {
    import DescribeCapacityReservationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest
      .builder()
      .optionallyWith(
        capacityReservationIds.map(value =>
          value.map { item =>
            CapacityReservationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capacityReservationIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeCapacityReservationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeCapacityReservationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCapacityReservationsRequest.wrap(buildAwsValue())
}
object DescribeCapacityReservationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCapacityReservationsRequest =
      zio.aws.ec2.model.DescribeCapacityReservationsRequest(
        capacityReservationIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def capacityReservationIds: Optional[List[CapacityReservationId]]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeCapacityReservationsMaxResults]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getCapacityReservationIds
        : ZIO[Any, AwsError, List[CapacityReservationId]] = AwsError
      .unwrapOptionField("capacityReservationIds", capacityReservationIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeCapacityReservationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest
  ) extends zio.aws.ec2.model.DescribeCapacityReservationsRequest.ReadOnly {
    override val capacityReservationIds: Optional[List[CapacityReservationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.CapacityReservationId(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[DescribeCapacityReservationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeCapacityReservationsMaxResults(value)
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest
  ): zio.aws.ec2.model.DescribeCapacityReservationsRequest.ReadOnly =
    new Wrapper(impl)
}
