package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeprovisionIpamPoolCidrRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamPoolId: IpamPoolId,
    cidr: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest = {
    import DeprovisionIpamPoolCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest.ReadOnly =
    zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest.wrap(buildAwsValue())
}
object DeprovisionIpamPoolCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest =
      zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest(
        dryRun.map(value => value),
        ipamPoolId,
        cidr.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def ipamPoolId: IpamPoolId
    def cidr: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest
  ) extends zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest
  ): zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest.ReadOnly = new Wrapper(
    impl
  )
}
