package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayConnectPeerId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayConnectPeerRequest(
    transitGatewayConnectPeerId: TransitGatewayConnectPeerId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest = {
    import DeleteTransitGatewayConnectPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest
      .builder()
      .transitGatewayConnectPeerId(
        TransitGatewayConnectPeerId.unwrap(
          transitGatewayConnectPeerId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayConnectPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest =
      zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest(
        transitGatewayConnectPeerId,
        dryRun.map(value => value)
      )
    def transitGatewayConnectPeerId: TransitGatewayConnectPeerId
    def dryRun: Optional[Boolean]
    def getTransitGatewayConnectPeerId
        : ZIO[Any, Nothing, TransitGatewayConnectPeerId] =
      ZIO.succeed(transitGatewayConnectPeerId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest.ReadOnly {
    override val transitGatewayConnectPeerId: TransitGatewayConnectPeerId =
      zio.aws.ec2.model.primitives
        .TransitGatewayConnectPeerId(impl.transitGatewayConnectPeerId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest.ReadOnly =
    new Wrapper(impl)
}
