package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorFilterRuleIdWithResolver
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorFilterRuleRequest(
    trafficMirrorFilterRuleId: TrafficMirrorFilterRuleIdWithResolver,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest = {
    import DeleteTrafficMirrorFilterRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
      .builder()
      .trafficMirrorFilterRuleId(
        TrafficMirrorFilterRuleIdWithResolver.unwrap(
          trafficMirrorFilterRuleId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorFilterRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest =
      zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest(
        trafficMirrorFilterRuleId,
        dryRun.map(value => value)
      )
    def trafficMirrorFilterRuleId: TrafficMirrorFilterRuleIdWithResolver
    def dryRun: Optional[Boolean]
    def getTrafficMirrorFilterRuleId
        : ZIO[Any, Nothing, TrafficMirrorFilterRuleIdWithResolver] =
      ZIO.succeed(trafficMirrorFilterRuleId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly {
    override val trafficMirrorFilterRuleId
        : TrafficMirrorFilterRuleIdWithResolver = zio.aws.ec2.model.primitives
      .TrafficMirrorFilterRuleIdWithResolver(impl.trafficMirrorFilterRuleId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly =
    new Wrapper(impl)
}
