package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteInstanceEventWindowRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    forceDelete: Optional[Boolean] = Optional.Absent,
    instanceEventWindowId: InstanceEventWindowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest = {
    import DeleteInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .instanceEventWindowId(
        InstanceEventWindowId.unwrap(instanceEventWindowId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.DeleteInstanceEventWindowRequest.wrap(buildAwsValue())
}
object DeleteInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteInstanceEventWindowRequest =
      zio.aws.ec2.model.DeleteInstanceEventWindowRequest(
        dryRun.map(value => value),
        forceDelete.map(value => value),
        instanceEventWindowId
      )
    def dryRun: Optional[Boolean]
    def forceDelete: Optional[Boolean]
    def instanceEventWindowId: InstanceEventWindowId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
    def getInstanceEventWindowId: ZIO[Any, Nothing, InstanceEventWindowId] =
      ZIO.succeed(instanceEventWindowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.DeleteInstanceEventWindowRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val forceDelete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => value: Boolean)
    override val instanceEventWindowId: InstanceEventWindowId =
      zio.aws.ec2.model.primitives
        .InstanceEventWindowId(impl.instanceEventWindowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest
  ): zio.aws.ec2.model.DeleteInstanceEventWindowRequest.ReadOnly = new Wrapper(
    impl
  )
}
