package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolCoipId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCoipCidrRequest(
    cidr: String,
    coipPoolId: Ipv4PoolCoipId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest = {
    import DeleteCoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .coipPoolId(Ipv4PoolCoipId.unwrap(coipPoolId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.DeleteCoipCidrRequest.wrap(buildAwsValue())
}
object DeleteCoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCoipCidrRequest = zio.aws.ec2.model
      .DeleteCoipCidrRequest(cidr, coipPoolId, dryRun.map(value => value))
    def cidr: String
    def coipPoolId: Ipv4PoolCoipId
    def dryRun: Optional[Boolean]
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getCoipPoolId: ZIO[Any, Nothing, Ipv4PoolCoipId] =
      ZIO.succeed(coipPoolId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest
  ) extends zio.aws.ec2.model.DeleteCoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val coipPoolId: Ipv4PoolCoipId =
      zio.aws.ec2.model.primitives.Ipv4PoolCoipId(impl.coipPoolId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest
  ): zio.aws.ec2.model.DeleteCoipCidrRequest.ReadOnly = new Wrapper(impl)
}
