package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ImageId, SnapshotId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateReplaceRootVolumeTaskRequest(
    instanceId: InstanceId,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    imageId: Optional[ImageId] = Optional.Absent,
    deleteReplacedRootVolume: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest = {
    import CreateReplaceRootVolumeTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        deleteReplacedRootVolume.map(value => value: java.lang.Boolean)
      )(_.deleteReplacedRootVolume)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest.ReadOnly =
    zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest.wrap(buildAwsValue())
}
object CreateReplaceRootVolumeTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest =
      zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest(
        instanceId,
        snapshotId.map(value => value),
        clientToken.map(value => value),
        dryRun.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        deleteReplacedRootVolume.map(value => value)
      )
    def instanceId: InstanceId
    def snapshotId: Optional[SnapshotId]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def imageId: Optional[ImageId]
    def deleteReplacedRootVolume: Optional[Boolean]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getDeleteReplacedRootVolume: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deleteReplacedRootVolume", deleteReplacedRootVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest
  ) extends zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val imageId: Optional[ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val deleteReplacedRootVolume: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteReplacedRootVolume())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest
  ): zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest.ReadOnly =
    new Wrapper(impl)
}
