package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkInsightsAccessScopeRequest(
    matchPaths: Optional[Iterable[zio.aws.ec2.model.AccessScopePathRequest]] =
      Optional.Absent,
    excludePaths: Optional[Iterable[zio.aws.ec2.model.AccessScopePathRequest]] =
      Optional.Absent,
    clientToken: String,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest = {
    import CreateNetworkInsightsAccessScopeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest
      .builder()
      .optionallyWith(
        matchPaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchPaths)
      .optionallyWith(
        excludePaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludePaths)
      .clientToken(clientToken: java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest
      .wrap(buildAwsValue())
}
object CreateNetworkInsightsAccessScopeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest =
      zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest(
        matchPaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludePaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def matchPaths
        : Optional[List[zio.aws.ec2.model.AccessScopePathRequest.ReadOnly]]
    def excludePaths
        : Optional[List[zio.aws.ec2.model.AccessScopePathRequest.ReadOnly]]
    def clientToken: String
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getMatchPaths: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AccessScopePathRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("matchPaths", matchPaths)
    def getExcludePaths: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AccessScopePathRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("excludePaths", excludePaths)
    def getClientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest
  ) extends zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest.ReadOnly {
    override val matchPaths
        : Optional[List[zio.aws.ec2.model.AccessScopePathRequest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchPaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AccessScopePathRequest.wrap(item)
          }.toList
        )
    override val excludePaths
        : Optional[List[zio.aws.ec2.model.AccessScopePathRequest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludePaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AccessScopePathRequest.wrap(item)
          }.toList
        )
    override val clientToken: String = impl.clientToken(): String
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest
  ): zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest.ReadOnly =
    new Wrapper(impl)
}
