package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateManagedPrefixListRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    prefixListName: String,
    entries: Optional[Iterable[zio.aws.ec2.model.AddPrefixListEntry]] =
      Optional.Absent,
    maxEntries: Integer,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    addressFamily: String,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest = {
    import CreateManagedPrefixListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .prefixListName(prefixListName: java.lang.String)
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .maxEntries(maxEntries: java.lang.Integer)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .addressFamily(addressFamily: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateManagedPrefixListRequest.ReadOnly =
    zio.aws.ec2.model.CreateManagedPrefixListRequest.wrap(buildAwsValue())
}
object CreateManagedPrefixListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateManagedPrefixListRequest =
      zio.aws.ec2.model.CreateManagedPrefixListRequest(
        dryRun.map(value => value),
        prefixListName,
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxEntries,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addressFamily,
        clientToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def prefixListName: String
    def entries: Optional[List[zio.aws.ec2.model.AddPrefixListEntry.ReadOnly]]
    def maxEntries: Integer
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def addressFamily: String
    def clientToken: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getPrefixListName: ZIO[Any, Nothing, String] =
      ZIO.succeed(prefixListName)
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddPrefixListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
    def getMaxEntries: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxEntries)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getAddressFamily: ZIO[Any, Nothing, String] = ZIO.succeed(addressFamily)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest
  ) extends zio.aws.ec2.model.CreateManagedPrefixListRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val prefixListName: String = impl.prefixListName(): String
    override val entries
        : Optional[List[zio.aws.ec2.model.AddPrefixListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AddPrefixListEntry.wrap(item)
          }.toList
        )
    override val maxEntries: Integer = impl.maxEntries(): Integer
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val addressFamily: String = impl.addressFamily(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest
  ): zio.aws.ec2.model.CreateManagedPrefixListRequest.ReadOnly = new Wrapper(
    impl
  )
}
