package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectionNotification(
    connectionNotificationId: Optional[String] = Optional.Absent,
    serviceId: Optional[String] = Optional.Absent,
    vpcEndpointId: Optional[String] = Optional.Absent,
    connectionNotificationType: Optional[
      zio.aws.ec2.model.ConnectionNotificationType
    ] = Optional.Absent,
    connectionNotificationArn: Optional[String] = Optional.Absent,
    connectionEvents: Optional[Iterable[String]] = Optional.Absent,
    connectionNotificationState: Optional[
      zio.aws.ec2.model.ConnectionNotificationState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConnectionNotification = {
    import ConnectionNotification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConnectionNotification
      .builder()
      .optionallyWith(
        connectionNotificationId.map(value => value: java.lang.String)
      )(_.connectionNotificationId)
      .optionallyWith(serviceId.map(value => value: java.lang.String))(
        _.serviceId
      )
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(connectionNotificationType.map(value => value.unwrap))(
        _.connectionNotificationType
      )
      .optionallyWith(
        connectionNotificationArn.map(value => value: java.lang.String)
      )(_.connectionNotificationArn)
      .optionallyWith(
        connectionEvents.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.connectionEvents)
      .optionallyWith(connectionNotificationState.map(value => value.unwrap))(
        _.connectionNotificationState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConnectionNotification.ReadOnly =
    zio.aws.ec2.model.ConnectionNotification.wrap(buildAwsValue())
}
object ConnectionNotification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConnectionNotification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConnectionNotification =
      zio.aws.ec2.model.ConnectionNotification(
        connectionNotificationId.map(value => value),
        serviceId.map(value => value),
        vpcEndpointId.map(value => value),
        connectionNotificationType.map(value => value),
        connectionNotificationArn.map(value => value),
        connectionEvents.map(value => value),
        connectionNotificationState.map(value => value)
      )
    def connectionNotificationId: Optional[String]
    def serviceId: Optional[String]
    def vpcEndpointId: Optional[String]
    def connectionNotificationType
        : Optional[zio.aws.ec2.model.ConnectionNotificationType]
    def connectionNotificationArn: Optional[String]
    def connectionEvents: Optional[List[String]]
    def connectionNotificationState
        : Optional[zio.aws.ec2.model.ConnectionNotificationState]
    def getConnectionNotificationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("connectionNotificationId", connectionNotificationId)
    def getServiceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getConnectionNotificationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectionNotificationType] =
      AwsError.unwrapOptionField(
        "connectionNotificationType",
        connectionNotificationType
      )
    def getConnectionNotificationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("connectionNotificationArn", connectionNotificationArn)
    def getConnectionEvents: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("connectionEvents", connectionEvents)
    def getConnectionNotificationState
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectionNotificationState] =
      AwsError.unwrapOptionField(
        "connectionNotificationState",
        connectionNotificationState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConnectionNotification
  ) extends zio.aws.ec2.model.ConnectionNotification.ReadOnly {
    override val connectionNotificationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionNotificationId())
        .map(value => value: String)
    override val serviceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value => value: String)
    override val vpcEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => value: String)
    override val connectionNotificationType
        : Optional[zio.aws.ec2.model.ConnectionNotificationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionNotificationType())
        .map(value => zio.aws.ec2.model.ConnectionNotificationType.wrap(value))
    override val connectionNotificationArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionNotificationArn())
        .map(value => value: String)
    override val connectionEvents: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionEvents())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val connectionNotificationState
        : Optional[zio.aws.ec2.model.ConnectionNotificationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionNotificationState())
        .map(value => zio.aws.ec2.model.ConnectionNotificationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConnectionNotification
  ): zio.aws.ec2.model.ConnectionNotification.ReadOnly = new Wrapper(impl)
}
