package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolCoipId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CoipCidr(
    cidr: Optional[String] = Optional.Absent,
    coipPoolId: Optional[Ipv4PoolCoipId] = Optional.Absent,
    localGatewayRouteTableId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.CoipCidr = {
    import CoipCidr.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CoipCidr
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(
        coipPoolId.map(value => Ipv4PoolCoipId.unwrap(value): java.lang.String)
      )(_.coipPoolId)
      .optionallyWith(
        localGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.localGatewayRouteTableId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CoipCidr.ReadOnly =
    zio.aws.ec2.model.CoipCidr.wrap(buildAwsValue())
}
object CoipCidr {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.CoipCidr] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CoipCidr = zio.aws.ec2.model.CoipCidr(
      cidr.map(value => value),
      coipPoolId.map(value => value),
      localGatewayRouteTableId.map(value => value)
    )
    def cidr: Optional[String]
    def coipPoolId: Optional[Ipv4PoolCoipId]
    def localGatewayRouteTableId: Optional[String]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getCoipPoolId: ZIO[Any, AwsError, Ipv4PoolCoipId] =
      AwsError.unwrapOptionField("coipPoolId", coipPoolId)
    def getLocalGatewayRouteTableId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CoipCidr
  ) extends zio.aws.ec2.model.CoipCidr.ReadOnly {
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val coipPoolId: Optional[Ipv4PoolCoipId] = zio.aws.core.internal
      .optionalFromNullable(impl.coipPoolId())
      .map(value => zio.aws.ec2.model.primitives.Ipv4PoolCoipId(value))
    override val localGatewayRouteTableId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CoipCidr
  ): zio.aws.ec2.model.CoipCidr.ReadOnly = new Wrapper(impl)
}
