package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VerifiedAccessTrustProviderId,
  VerifiedAccessInstanceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachVerifiedAccessTrustProviderRequest(
    verifiedAccessInstanceId: VerifiedAccessInstanceId,
    verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest = {
    import AttachVerifiedAccessTrustProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest
      .builder()
      .verifiedAccessInstanceId(
        VerifiedAccessInstanceId.unwrap(
          verifiedAccessInstanceId
        ): java.lang.String
      )
      .verifiedAccessTrustProviderId(
        VerifiedAccessTrustProviderId.unwrap(
          verifiedAccessTrustProviderId
        ): java.lang.String
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest.ReadOnly =
    zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest
      .wrap(buildAwsValue())
}
object AttachVerifiedAccessTrustProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest =
      zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest(
        verifiedAccessInstanceId,
        verifiedAccessTrustProviderId,
        clientToken.map(value => value),
        dryRun.map(value => value)
      )
    def verifiedAccessInstanceId: VerifiedAccessInstanceId
    def verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def getVerifiedAccessInstanceId
        : ZIO[Any, Nothing, VerifiedAccessInstanceId] =
      ZIO.succeed(verifiedAccessInstanceId)
    def getVerifiedAccessTrustProviderId
        : ZIO[Any, Nothing, VerifiedAccessTrustProviderId] =
      ZIO.succeed(verifiedAccessTrustProviderId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest
  ) extends zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest.ReadOnly {
    override val verifiedAccessInstanceId: VerifiedAccessInstanceId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessInstanceId(impl.verifiedAccessInstanceId())
    override val verifiedAccessTrustProviderId: VerifiedAccessTrustProviderId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessTrustProviderId(impl.verifiedAccessTrustProviderId())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest
  ): zio.aws.ec2.model.AttachVerifiedAccessTrustProviderRequest.ReadOnly =
    new Wrapper(impl)
}
