package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{AllocationId, NatGatewayId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateNatGatewayAddressRequest(
    natGatewayId: NatGatewayId,
    allocationIds: Iterable[AllocationId],
    privateIpAddresses: Optional[Iterable[String]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest = {
    import AssociateNatGatewayAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest
      .builder()
      .natGatewayId(NatGatewayId.unwrap(natGatewayId): java.lang.String)
      .allocationIds(allocationIds.map { item =>
        AllocationId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateNatGatewayAddressRequest.ReadOnly =
    zio.aws.ec2.model.AssociateNatGatewayAddressRequest.wrap(buildAwsValue())
}
object AssociateNatGatewayAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateNatGatewayAddressRequest =
      zio.aws.ec2.model.AssociateNatGatewayAddressRequest(
        natGatewayId,
        allocationIds,
        privateIpAddresses.map(value => value),
        dryRun.map(value => value)
      )
    def natGatewayId: NatGatewayId
    def allocationIds: List[AllocationId]
    def privateIpAddresses: Optional[List[String]]
    def dryRun: Optional[Boolean]
    def getNatGatewayId: ZIO[Any, Nothing, NatGatewayId] =
      ZIO.succeed(natGatewayId)
    def getAllocationIds: ZIO[Any, Nothing, List[AllocationId]] =
      ZIO.succeed(allocationIds)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest
  ) extends zio.aws.ec2.model.AssociateNatGatewayAddressRequest.ReadOnly {
    override val natGatewayId: NatGatewayId =
      zio.aws.ec2.model.primitives.NatGatewayId(impl.natGatewayId())
    override val allocationIds: List[AllocationId] = impl
      .allocationIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.AllocationId(item)
      }
      .toList
    override val privateIpAddresses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest
  ): zio.aws.ec2.model.AssociateNatGatewayAddressRequest.ReadOnly = new Wrapper(
    impl
  )
}
