package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RoleId, CertificateId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateEnclaveCertificateIamRoleRequest(
    certificateArn: CertificateId,
    roleArn: RoleId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest = {
    import AssociateEnclaveCertificateIamRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest
      .builder()
      .certificateArn(CertificateId.unwrap(certificateArn): java.lang.String)
      .roleArn(RoleId.unwrap(roleArn): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest.ReadOnly =
    zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest
      .wrap(buildAwsValue())
}
object AssociateEnclaveCertificateIamRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest =
      zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest(
        certificateArn,
        roleArn,
        dryRun.map(value => value)
      )
    def certificateArn: CertificateId
    def roleArn: RoleId
    def dryRun: Optional[Boolean]
    def getCertificateArn: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateArn)
    def getRoleArn: ZIO[Any, Nothing, RoleId] = ZIO.succeed(roleArn)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest
  ) extends zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest.ReadOnly {
    override val certificateArn: CertificateId =
      zio.aws.ec2.model.primitives.CertificateId(impl.certificateArn())
    override val roleArn: RoleId =
      zio.aws.ec2.model.primitives.RoleId(impl.roleArn())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest
  ): zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest.ReadOnly =
    new Wrapper(impl)
}
