package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcPeeringConnectionIdWithResolver
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptVpcPeeringConnectionRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    vpcPeeringConnectionId: VpcPeeringConnectionIdWithResolver
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest = {
    import AcceptVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .vpcPeeringConnectionId(
        VpcPeeringConnectionIdWithResolver.unwrap(
          vpcPeeringConnectionId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.wrap(buildAwsValue())
}
object AcceptVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest =
      zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest(
        dryRun.map(value => value),
        vpcPeeringConnectionId
      )
    def dryRun: Optional[Boolean]
    def vpcPeeringConnectionId: VpcPeeringConnectionIdWithResolver
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getVpcPeeringConnectionId
        : ZIO[Any, Nothing, VpcPeeringConnectionIdWithResolver] =
      ZIO.succeed(vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ) extends zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val vpcPeeringConnectionId: VpcPeeringConnectionIdWithResolver =
      zio.aws.ec2.model.primitives
        .VpcPeeringConnectionIdWithResolver(impl.vpcPeeringConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ): zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
