package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcEndpointId, VpcEndpointServiceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptVpcEndpointConnectionsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    serviceId: VpcEndpointServiceId,
    vpcEndpointIds: Iterable[VpcEndpointId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest = {
    import AcceptVpcEndpointConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .vpcEndpointIds(vpcEndpointIds.map { item =>
        VpcEndpointId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest.wrap(buildAwsValue())
}
object AcceptVpcEndpointConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest =
      zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest(
        dryRun.map(value => value),
        serviceId,
        vpcEndpointIds
      )
    def dryRun: Optional[Boolean]
    def serviceId: VpcEndpointServiceId
    def vpcEndpointIds: List[VpcEndpointId]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getVpcEndpointIds: ZIO[Any, Nothing, List[VpcEndpointId]] =
      ZIO.succeed(vpcEndpointIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest
  ) extends zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val vpcEndpointIds: List[VpcEndpointId] = impl
      .vpcEndpointIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.VpcEndpointId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest
  ): zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
