package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidationWarning(
    errors: Optional[Iterable[zio.aws.ec2.model.ValidationError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ValidationWarning = {
    import ValidationWarning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ValidationWarning
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ValidationWarning.ReadOnly =
    zio.aws.ec2.model.ValidationWarning.wrap(buildAwsValue())
}
object ValidationWarning {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ValidationWarning
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ValidationWarning =
      zio.aws.ec2.model.ValidationWarning(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[List[zio.aws.ec2.model.ValidationError.ReadOnly]]
    def getErrors
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ValidationError.ReadOnly]] =
      AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ValidationWarning
  ) extends zio.aws.ec2.model.ValidationWarning.ReadOnly {
    override val errors
        : Optional[List[zio.aws.ec2.model.ValidationError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ValidationError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ValidationWarning
  ): zio.aws.ec2.model.ValidationWarning.ReadOnly = new Wrapper(impl)
}
