package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayRouteTableState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState
}
object TransitGatewayRouteTableState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState
  ): zio.aws.ec2.model.TransitGatewayRouteTableState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayRouteTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.TransitGatewayRouteTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.PENDING
  }
  case object available
      extends zio.aws.ec2.model.TransitGatewayRouteTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.AVAILABLE
  }
  case object deleting extends zio.aws.ec2.model.TransitGatewayRouteTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.TransitGatewayRouteTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableState.DELETED
  }
}
