package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetReservationValue(
    reservationValue: Optional[zio.aws.ec2.model.ReservationValue] =
      Optional.Absent,
    targetConfiguration: Optional[zio.aws.ec2.model.TargetConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetReservationValue = {
    import TargetReservationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetReservationValue
      .builder()
      .optionallyWith(reservationValue.map(value => value.buildAwsValue()))(
        _.reservationValue
      )
      .optionallyWith(targetConfiguration.map(value => value.buildAwsValue()))(
        _.targetConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetReservationValue.ReadOnly =
    zio.aws.ec2.model.TargetReservationValue.wrap(buildAwsValue())
}
object TargetReservationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TargetReservationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetReservationValue =
      zio.aws.ec2.model.TargetReservationValue(
        reservationValue.map(value => value.asEditable),
        targetConfiguration.map(value => value.asEditable)
      )
    def reservationValue: Optional[zio.aws.ec2.model.ReservationValue.ReadOnly]
    def targetConfiguration
        : Optional[zio.aws.ec2.model.TargetConfiguration.ReadOnly]
    def getReservationValue
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReservationValue.ReadOnly] =
      AwsError.unwrapOptionField("reservationValue", reservationValue)
    def getTargetConfiguration
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("targetConfiguration", targetConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetReservationValue
  ) extends zio.aws.ec2.model.TargetReservationValue.ReadOnly {
    override val reservationValue
        : Optional[zio.aws.ec2.model.ReservationValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservationValue())
        .map(value => zio.aws.ec2.model.ReservationValue.wrap(value))
    override val targetConfiguration
        : Optional[zio.aws.ec2.model.TargetConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetConfiguration())
        .map(value => zio.aws.ec2.model.TargetConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetReservationValue
  ): zio.aws.ec2.model.TargetReservationValue.ReadOnly = new Wrapper(impl)
}
