package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Subscription(
    source: Optional[String] = Optional.Absent,
    destination: Optional[String] = Optional.Absent,
    metric: Optional[zio.aws.ec2.model.MetricType] = Optional.Absent,
    statistic: Optional[zio.aws.ec2.model.StatisticType] = Optional.Absent,
    period: Optional[zio.aws.ec2.model.PeriodType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Subscription = {
    import Subscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Subscription
      .builder()
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(destination.map(value => value: java.lang.String))(
        _.destination
      )
      .optionallyWith(metric.map(value => value.unwrap))(_.metric)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Subscription.ReadOnly =
    zio.aws.ec2.model.Subscription.wrap(buildAwsValue())
}
object Subscription {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Subscription] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Subscription =
      zio.aws.ec2.model.Subscription(
        source.map(value => value),
        destination.map(value => value),
        metric.map(value => value),
        statistic.map(value => value),
        period.map(value => value)
      )
    def source: Optional[String]
    def destination: Optional[String]
    def metric: Optional[zio.aws.ec2.model.MetricType]
    def statistic: Optional[zio.aws.ec2.model.StatisticType]
    def period: Optional[zio.aws.ec2.model.PeriodType]
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destination", destination)
    def getMetric: ZIO[Any, AwsError, zio.aws.ec2.model.MetricType] =
      AwsError.unwrapOptionField("metric", metric)
    def getStatistic: ZIO[Any, AwsError, zio.aws.ec2.model.StatisticType] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getPeriod: ZIO[Any, AwsError, zio.aws.ec2.model.PeriodType] =
      AwsError.unwrapOptionField("period", period)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Subscription
  ) extends zio.aws.ec2.model.Subscription.ReadOnly {
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val destination: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => value: String)
    override val metric: Optional[zio.aws.ec2.model.MetricType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metric())
        .map(value => zio.aws.ec2.model.MetricType.wrap(value))
    override val statistic: Optional[zio.aws.ec2.model.StatisticType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.ec2.model.StatisticType.wrap(value))
    override val period: Optional[zio.aws.ec2.model.PeriodType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.period())
        .map(value => zio.aws.ec2.model.PeriodType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Subscription
  ): zio.aws.ec2.model.Subscription.ReadOnly = new Wrapper(impl)
}
