package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import scala.jdk.CollectionConverters._
final case class SpotFleetRequestConfigData(
    allocationStrategy: Optional[zio.aws.ec2.model.AllocationStrategy] =
      Optional.Absent,
    onDemandAllocationStrategy: Optional[
      zio.aws.ec2.model.OnDemandAllocationStrategy
    ] = Optional.Absent,
    spotMaintenanceStrategies: Optional[
      zio.aws.ec2.model.SpotMaintenanceStrategies
    ] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    excessCapacityTerminationPolicy: Optional[
      zio.aws.ec2.model.ExcessCapacityTerminationPolicy
    ] = Optional.Absent,
    fulfilledCapacity: Optional[Double] = Optional.Absent,
    onDemandFulfilledCapacity: Optional[Double] = Optional.Absent,
    iamFleetRole: String,
    launchSpecifications: Optional[
      Iterable[zio.aws.ec2.model.SpotFleetLaunchSpecification]
    ] = Optional.Absent,
    launchTemplateConfigs: Optional[
      Iterable[zio.aws.ec2.model.LaunchTemplateConfig]
    ] = Optional.Absent,
    spotPrice: Optional[String] = Optional.Absent,
    targetCapacity: Integer,
    onDemandTargetCapacity: Optional[Integer] = Optional.Absent,
    onDemandMaxTotalPrice: Optional[String] = Optional.Absent,
    spotMaxTotalPrice: Optional[String] = Optional.Absent,
    terminateInstancesWithExpiration: Optional[Boolean] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.FleetType] = Optional.Absent,
    validFrom: Optional[DateTime] = Optional.Absent,
    validUntil: Optional[DateTime] = Optional.Absent,
    replaceUnhealthyInstances: Optional[Boolean] = Optional.Absent,
    instanceInterruptionBehavior: Optional[
      zio.aws.ec2.model.InstanceInterruptionBehavior
    ] = Optional.Absent,
    loadBalancersConfig: Optional[zio.aws.ec2.model.LoadBalancersConfig] =
      Optional.Absent,
    instancePoolsToUseCount: Optional[Integer] = Optional.Absent,
    context: Optional[String] = Optional.Absent,
    targetCapacityUnitType: Optional[zio.aws.ec2.model.TargetCapacityUnitType] =
      Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData = {
    import SpotFleetRequestConfigData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData
      .builder()
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .optionallyWith(onDemandAllocationStrategy.map(value => value.unwrap))(
        _.onDemandAllocationStrategy
      )
      .optionallyWith(
        spotMaintenanceStrategies.map(value => value.buildAwsValue())
      )(_.spotMaintenanceStrategies)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .optionallyWith(fulfilledCapacity.map(value => value: java.lang.Double))(
        _.fulfilledCapacity
      )
      .optionallyWith(
        onDemandFulfilledCapacity.map(value => value: java.lang.Double)
      )(_.onDemandFulfilledCapacity)
      .iamFleetRole(iamFleetRole: java.lang.String)
      .optionallyWith(
        launchSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchSpecifications)
      .optionallyWith(
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateConfigs)
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .targetCapacity(targetCapacity: java.lang.Integer)
      .optionallyWith(
        onDemandTargetCapacity.map(value => value: java.lang.Integer)
      )(_.onDemandTargetCapacity)
      .optionallyWith(
        onDemandMaxTotalPrice.map(value => value: java.lang.String)
      )(_.onDemandMaxTotalPrice)
      .optionallyWith(spotMaxTotalPrice.map(value => value: java.lang.String))(
        _.spotMaxTotalPrice
      )
      .optionallyWith(
        terminateInstancesWithExpiration.map(value => value: java.lang.Boolean)
      )(_.terminateInstancesWithExpiration)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        replaceUnhealthyInstances.map(value => value: java.lang.Boolean)
      )(_.replaceUnhealthyInstances)
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .optionallyWith(loadBalancersConfig.map(value => value.buildAwsValue()))(
        _.loadBalancersConfig
      )
      .optionallyWith(
        instancePoolsToUseCount.map(value => value: java.lang.Integer)
      )(_.instancePoolsToUseCount)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .optionallyWith(targetCapacityUnitType.map(value => value.unwrap))(
        _.targetCapacityUnitType
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly =
    zio.aws.ec2.model.SpotFleetRequestConfigData.wrap(buildAwsValue())
}
object SpotFleetRequestConfigData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotFleetRequestConfigData =
      zio.aws.ec2.model.SpotFleetRequestConfigData(
        allocationStrategy.map(value => value),
        onDemandAllocationStrategy.map(value => value),
        spotMaintenanceStrategies.map(value => value.asEditable),
        clientToken.map(value => value),
        excessCapacityTerminationPolicy.map(value => value),
        fulfilledCapacity.map(value => value),
        onDemandFulfilledCapacity.map(value => value),
        iamFleetRole,
        launchSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        spotPrice.map(value => value),
        targetCapacity,
        onDemandTargetCapacity.map(value => value),
        onDemandMaxTotalPrice.map(value => value),
        spotMaxTotalPrice.map(value => value),
        terminateInstancesWithExpiration.map(value => value),
        `type`.map(value => value),
        validFrom.map(value => value),
        validUntil.map(value => value),
        replaceUnhealthyInstances.map(value => value),
        instanceInterruptionBehavior.map(value => value),
        loadBalancersConfig.map(value => value.asEditable),
        instancePoolsToUseCount.map(value => value),
        context.map(value => value),
        targetCapacityUnitType.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allocationStrategy: Optional[zio.aws.ec2.model.AllocationStrategy]
    def onDemandAllocationStrategy
        : Optional[zio.aws.ec2.model.OnDemandAllocationStrategy]
    def spotMaintenanceStrategies
        : Optional[zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly]
    def clientToken: Optional[String]
    def excessCapacityTerminationPolicy
        : Optional[zio.aws.ec2.model.ExcessCapacityTerminationPolicy]
    def fulfilledCapacity: Optional[Double]
    def onDemandFulfilledCapacity: Optional[Double]
    def iamFleetRole: String
    def launchSpecifications: Optional[
      List[zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly]
    ]
    def launchTemplateConfigs
        : Optional[List[zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly]]
    def spotPrice: Optional[String]
    def targetCapacity: Integer
    def onDemandTargetCapacity: Optional[Integer]
    def onDemandMaxTotalPrice: Optional[String]
    def spotMaxTotalPrice: Optional[String]
    def terminateInstancesWithExpiration: Optional[Boolean]
    def `type`: Optional[zio.aws.ec2.model.FleetType]
    def validFrom: Optional[DateTime]
    def validUntil: Optional[DateTime]
    def replaceUnhealthyInstances: Optional[Boolean]
    def instanceInterruptionBehavior
        : Optional[zio.aws.ec2.model.InstanceInterruptionBehavior]
    def loadBalancersConfig
        : Optional[zio.aws.ec2.model.LoadBalancersConfig.ReadOnly]
    def instancePoolsToUseCount: Optional[Integer]
    def context: Optional[String]
    def targetCapacityUnitType
        : Optional[zio.aws.ec2.model.TargetCapacityUnitType]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getAllocationStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.AllocationStrategy] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getOnDemandAllocationStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.OnDemandAllocationStrategy] =
      AwsError.unwrapOptionField(
        "onDemandAllocationStrategy",
        onDemandAllocationStrategy
      )
    def getSpotMaintenanceStrategies: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly
    ] = AwsError.unwrapOptionField(
      "spotMaintenanceStrategies",
      spotMaintenanceStrategies
    )
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getFulfilledCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fulfilledCapacity", fulfilledCapacity)
    def getOnDemandFulfilledCapacity: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("onDemandFulfilledCapacity", onDemandFulfilledCapacity)
    def getIamFleetRole: ZIO[Any, Nothing, String] = ZIO.succeed(iamFleetRole)
    def getLaunchSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchSpecifications", launchSpecifications)
    def getLaunchTemplateConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchTemplateConfigs", launchTemplateConfigs)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getTargetCapacity: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(targetCapacity)
    def getOnDemandTargetCapacity: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("onDemandTargetCapacity", onDemandTargetCapacity)
    def getOnDemandMaxTotalPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("onDemandMaxTotalPrice", onDemandMaxTotalPrice)
    def getSpotMaxTotalPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotMaxTotalPrice", spotMaxTotalPrice)
    def getTerminateInstancesWithExpiration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "terminateInstancesWithExpiration",
        terminateInstancesWithExpiration
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getReplaceUnhealthyInstances: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("replaceUnhealthyInstances", replaceUnhealthyInstances)
    def getInstanceInterruptionBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceInterruptionBehavior] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
    def getLoadBalancersConfig
        : ZIO[Any, AwsError, zio.aws.ec2.model.LoadBalancersConfig.ReadOnly] =
      AwsError.unwrapOptionField("loadBalancersConfig", loadBalancersConfig)
    def getInstancePoolsToUseCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("instancePoolsToUseCount", instancePoolsToUseCount)
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
    def getTargetCapacityUnitType
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetCapacityUnitType] =
      AwsError.unwrapOptionField(
        "targetCapacityUnitType",
        targetCapacityUnitType
      )
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData
  ) extends zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly {
    override val allocationStrategy
        : Optional[zio.aws.ec2.model.AllocationStrategy] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationStrategy())
      .map(value => zio.aws.ec2.model.AllocationStrategy.wrap(value))
    override val onDemandAllocationStrategy
        : Optional[zio.aws.ec2.model.OnDemandAllocationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandAllocationStrategy())
        .map(value => zio.aws.ec2.model.OnDemandAllocationStrategy.wrap(value))
    override val spotMaintenanceStrategies
        : Optional[zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotMaintenanceStrategies())
        .map(value => zio.aws.ec2.model.SpotMaintenanceStrategies.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val excessCapacityTerminationPolicy
        : Optional[zio.aws.ec2.model.ExcessCapacityTerminationPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excessCapacityTerminationPolicy())
        .map(value =>
          zio.aws.ec2.model.ExcessCapacityTerminationPolicy.wrap(value)
        )
    override val fulfilledCapacity: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fulfilledCapacity())
      .map(value => value: Double)
    override val onDemandFulfilledCapacity: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandFulfilledCapacity())
        .map(value => value: Double)
    override val iamFleetRole: String = impl.iamFleetRole(): String
    override val launchSpecifications: Optional[
      List[zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SpotFleetLaunchSpecification.wrap(item)
        }.toList
      )
    override val launchTemplateConfigs
        : Optional[List[zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LaunchTemplateConfig.wrap(item)
          }.toList
        )
    override val spotPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotPrice())
      .map(value => value: String)
    override val targetCapacity: Integer = impl.targetCapacity(): Integer
    override val onDemandTargetCapacity: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandTargetCapacity())
        .map(value => value: Integer)
    override val onDemandMaxTotalPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.onDemandMaxTotalPrice())
      .map(value => value: String)
    override val spotMaxTotalPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotMaxTotalPrice())
      .map(value => value: String)
    override val terminateInstancesWithExpiration: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminateInstancesWithExpiration())
        .map(value => value: Boolean)
    override val `type`: Optional[zio.aws.ec2.model.FleetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.FleetType.wrap(value))
    override val validFrom: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val replaceUnhealthyInstances: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replaceUnhealthyInstances())
        .map(value => value: Boolean)
    override val instanceInterruptionBehavior
        : Optional[zio.aws.ec2.model.InstanceInterruptionBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInterruptionBehavior())
        .map(value =>
          zio.aws.ec2.model.InstanceInterruptionBehavior.wrap(value)
        )
    override val loadBalancersConfig
        : Optional[zio.aws.ec2.model.LoadBalancersConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancersConfig())
        .map(value => zio.aws.ec2.model.LoadBalancersConfig.wrap(value))
    override val instancePoolsToUseCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instancePoolsToUseCount())
        .map(value => value: Integer)
    override val context: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.context())
      .map(value => value: String)
    override val targetCapacityUnitType
        : Optional[zio.aws.ec2.model.TargetCapacityUnitType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetCapacityUnitType())
        .map(value => zio.aws.ec2.model.TargetCapacityUnitType.wrap(value))
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData
  ): zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly = new Wrapper(impl)
}
