package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityGroupForVpc(
    description: Optional[String] = Optional.Absent,
    groupName: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    groupId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    primaryVpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc = {
    import SecurityGroupForVpc.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(primaryVpcId.map(value => value: java.lang.String))(
        _.primaryVpcId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupForVpc.ReadOnly =
    zio.aws.ec2.model.SecurityGroupForVpc.wrap(buildAwsValue())
}
object SecurityGroupForVpc {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupForVpc =
      zio.aws.ec2.model.SecurityGroupForVpc(
        description.map(value => value),
        groupName.map(value => value),
        ownerId.map(value => value),
        groupId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        primaryVpcId.map(value => value)
      )
    def description: Optional[String]
    def groupName: Optional[String]
    def ownerId: Optional[String]
    def groupId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def primaryVpcId: Optional[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPrimaryVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryVpcId", primaryVpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc
  ) extends zio.aws.ec2.model.SecurityGroupForVpc.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val primaryVpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryVpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc
  ): zio.aws.ec2.model.SecurityGroupForVpc.ReadOnly = new Wrapper(impl)
}
