package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait Scope {
  def unwrap: software.amazon.awssdk.services.ec2.model.Scope
}
object Scope {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.Scope
  ): zio.aws.ec2.model.Scope = value match {
    case software.amazon.awssdk.services.ec2.model.Scope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.Scope.AVAILABILITY_ZONE =>
      val r = `Availability Zone`
      r
    case software.amazon.awssdk.services.ec2.model.Scope.REGION =>
      val r = Region
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.Scope {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Scope =
      software.amazon.awssdk.services.ec2.model.Scope.UNKNOWN_TO_SDK_VERSION
  }
  case object `Availability Zone` extends zio.aws.ec2.model.Scope {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Scope =
      software.amazon.awssdk.services.ec2.model.Scope.AVAILABILITY_ZONE
  }
  case object Region extends zio.aws.ec2.model.Scope {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Scope =
      software.amazon.awssdk.services.ec2.model.Scope.REGION
  }
}
