package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ScheduledInstanceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RunScheduledInstancesRequest(
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    launchSpecification: zio.aws.ec2.model.ScheduledInstancesLaunchSpecification,
    scheduledInstanceId: ScheduledInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest = {
    import RunScheduledInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .launchSpecification(launchSpecification.buildAwsValue())
      .scheduledInstanceId(
        ScheduledInstanceId.unwrap(scheduledInstanceId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RunScheduledInstancesRequest.ReadOnly =
    zio.aws.ec2.model.RunScheduledInstancesRequest.wrap(buildAwsValue())
}
object RunScheduledInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RunScheduledInstancesRequest =
      zio.aws.ec2.model.RunScheduledInstancesRequest(
        clientToken.map(value => value),
        dryRun.map(value => value),
        instanceCount.map(value => value),
        launchSpecification.asEditable,
        scheduledInstanceId
      )
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def instanceCount: Optional[Integer]
    def launchSpecification
        : zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly
    def scheduledInstanceId: ScheduledInstanceId
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getLaunchSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly
    ] = ZIO.succeed(launchSpecification)
    def getScheduledInstanceId: ZIO[Any, Nothing, ScheduledInstanceId] =
      ZIO.succeed(scheduledInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest
  ) extends zio.aws.ec2.model.RunScheduledInstancesRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val launchSpecification
        : zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly =
      zio.aws.ec2.model.ScheduledInstancesLaunchSpecification
        .wrap(impl.launchSpecification())
    override val scheduledInstanceId: ScheduledInstanceId =
      zio.aws.ec2.model.primitives
        .ScheduledInstanceId(impl.scheduledInstanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest
  ): zio.aws.ec2.model.RunScheduledInstancesRequest.ReadOnly = new Wrapper(impl)
}
