package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.PrefixListResourceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreManagedPrefixListVersionRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    prefixListId: PrefixListResourceId,
    previousVersion: Long,
    currentVersion: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest = {
    import RestoreManagedPrefixListVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .previousVersion(previousVersion: java.lang.Long)
      .currentVersion(currentVersion: java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest.ReadOnly =
    zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest
      .wrap(buildAwsValue())
}
object RestoreManagedPrefixListVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest =
      zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest(
        dryRun.map(value => value),
        prefixListId,
        previousVersion,
        currentVersion
      )
    def dryRun: Optional[Boolean]
    def prefixListId: PrefixListResourceId
    def previousVersion: Long
    def currentVersion: Long
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getPreviousVersion: ZIO[Any, Nothing, Long] =
      ZIO.succeed(previousVersion)
    def getCurrentVersion: ZIO[Any, Nothing, Long] = ZIO.succeed(currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest
  ) extends zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val previousVersion: Long = impl.previousVersion(): Long
    override val currentVersion: Long = impl.currentVersion(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest
  ): zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest.ReadOnly =
    new Wrapper(impl)
}
