package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreImageFromRecycleBinRequest(
    imageId: ImageId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest = {
    import RestoreImageFromRecycleBinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreImageFromRecycleBinRequest.ReadOnly =
    zio.aws.ec2.model.RestoreImageFromRecycleBinRequest.wrap(buildAwsValue())
}
object RestoreImageFromRecycleBinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreImageFromRecycleBinRequest =
      zio.aws.ec2.model
        .RestoreImageFromRecycleBinRequest(imageId, dryRun.map(value => value))
    def imageId: ImageId
    def dryRun: Optional[Boolean]
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest
  ) extends zio.aws.ec2.model.RestoreImageFromRecycleBinRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest
  ): zio.aws.ec2.model.RestoreImageFromRecycleBinRequest.ReadOnly = new Wrapper(
    impl
  )
}
