package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ReservationState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ReservationState
}
object ReservationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ReservationState
  ): zio.aws.ec2.model.ReservationState = value match {
    case software.amazon.awssdk.services.ec2.model.ReservationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ReservationState.PAYMENT_PENDING =>
      val r = `payment-pending`
      r
    case software.amazon.awssdk.services.ec2.model.ReservationState.PAYMENT_FAILED =>
      val r = `payment-failed`
      r
    case software.amazon.awssdk.services.ec2.model.ReservationState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.ReservationState.RETIRED =>
      val r = retired
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservationState =
      software.amazon.awssdk.services.ec2.model.ReservationState.UNKNOWN_TO_SDK_VERSION
  }
  case object `payment-pending` extends zio.aws.ec2.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservationState =
      software.amazon.awssdk.services.ec2.model.ReservationState.PAYMENT_PENDING
  }
  case object `payment-failed` extends zio.aws.ec2.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservationState =
      software.amazon.awssdk.services.ec2.model.ReservationState.PAYMENT_FAILED
  }
  case object active extends zio.aws.ec2.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservationState =
      software.amazon.awssdk.services.ec2.model.ReservationState.ACTIVE
  }
  case object retired extends zio.aws.ec2.model.ReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservationState =
      software.amazon.awssdk.services.ec2.model.ReservationState.RETIRED
  }
}
