package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{InstanceId, DateTime}
import scala.jdk.CollectionConverters._
final case class ReportInstanceStatusRequest(
    description: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent,
    instances: Iterable[InstanceId],
    reasonCodes: Iterable[zio.aws.ec2.model.ReportInstanceReasonCodes],
    startTime: Optional[DateTime] = Optional.Absent,
    status: zio.aws.ec2.model.ReportStatusType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest = {
    import ReportInstanceStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .instances(instances.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .reasonCodesWithStrings(reasonCodes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReportInstanceStatusRequest.ReadOnly =
    zio.aws.ec2.model.ReportInstanceStatusRequest.wrap(buildAwsValue())
}
object ReportInstanceStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReportInstanceStatusRequest =
      zio.aws.ec2.model.ReportInstanceStatusRequest(
        description.map(value => value),
        dryRun.map(value => value),
        endTime.map(value => value),
        instances,
        reasonCodes,
        startTime.map(value => value),
        status
      )
    def description: Optional[String]
    def dryRun: Optional[Boolean]
    def endTime: Optional[DateTime]
    def instances: List[InstanceId]
    def reasonCodes: List[zio.aws.ec2.model.ReportInstanceReasonCodes]
    def startTime: Optional[DateTime]
    def status: zio.aws.ec2.model.ReportStatusType
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getInstances: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instances)
    def getReasonCodes
        : ZIO[Any, Nothing, List[zio.aws.ec2.model.ReportInstanceReasonCodes]] =
      ZIO.succeed(reasonCodes)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.ec2.model.ReportStatusType] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest
  ) extends zio.aws.ec2.model.ReportInstanceStatusRequest.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val instances: List[InstanceId] = impl
      .instances()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.InstanceId(item)
      }
      .toList
    override val reasonCodes
        : List[zio.aws.ec2.model.ReportInstanceReasonCodes] = impl
      .reasonCodes()
      .asScala
      .map { item =>
        zio.aws.ec2.model.ReportInstanceReasonCodes.wrap(item)
      }
      .toList
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val status: zio.aws.ec2.model.ReportStatusType =
      zio.aws.ec2.model.ReportStatusType.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest
  ): zio.aws.ec2.model.ReportInstanceStatusRequest.ReadOnly = new Wrapper(impl)
}
