package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  InstanceId,
  RouteTableId,
  CarrierGatewayId,
  EgressOnlyInternetGatewayId,
  TransitGatewayId,
  CoreNetworkArn,
  NatGatewayId,
  VpcPeeringConnectionId,
  RouteGatewayId,
  VpcEndpointId,
  LocalGatewayId,
  PrefixListResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceRouteRequest(
    destinationCidrBlock: Optional[String] = Optional.Absent,
    destinationIpv6CidrBlock: Optional[String] = Optional.Absent,
    destinationPrefixListId: Optional[PrefixListResourceId] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    vpcEndpointId: Optional[VpcEndpointId] = Optional.Absent,
    egressOnlyInternetGatewayId: Optional[EgressOnlyInternetGatewayId] =
      Optional.Absent,
    gatewayId: Optional[RouteGatewayId] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    localTarget: Optional[Boolean] = Optional.Absent,
    natGatewayId: Optional[NatGatewayId] = Optional.Absent,
    transitGatewayId: Optional[TransitGatewayId] = Optional.Absent,
    localGatewayId: Optional[LocalGatewayId] = Optional.Absent,
    carrierGatewayId: Optional[CarrierGatewayId] = Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    routeTableId: RouteTableId,
    vpcPeeringConnectionId: Optional[VpcPeeringConnectionId] = Optional.Absent,
    coreNetworkArn: Optional[CoreNetworkArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest = {
    import ReplaceRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationIpv6CidrBlock.map(value => value: java.lang.String)
      )(_.destinationIpv6CidrBlock)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value =>
          EgressOnlyInternetGatewayId.unwrap(value): java.lang.String
        )
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(
        gatewayId.map(value => RouteGatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(localTarget.map(value => value: java.lang.Boolean))(
        _.localTarget
      )
      .optionallyWith(
        natGatewayId.map(value => NatGatewayId.unwrap(value): java.lang.String)
      )(_.natGatewayId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(
        localGatewayId.map(value =>
          LocalGatewayId.unwrap(value): java.lang.String
        )
      )(_.localGatewayId)
      .optionallyWith(
        carrierGatewayId.map(value =>
          CarrierGatewayId.unwrap(value): java.lang.String
        )
      )(_.carrierGatewayId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          VpcPeeringConnectionId.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReplaceRouteRequest.ReadOnly =
    zio.aws.ec2.model.ReplaceRouteRequest.wrap(buildAwsValue())
}
object ReplaceRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceRouteRequest =
      zio.aws.ec2.model.ReplaceRouteRequest(
        destinationCidrBlock.map(value => value),
        destinationIpv6CidrBlock.map(value => value),
        destinationPrefixListId.map(value => value),
        dryRun.map(value => value),
        vpcEndpointId.map(value => value),
        egressOnlyInternetGatewayId.map(value => value),
        gatewayId.map(value => value),
        instanceId.map(value => value),
        localTarget.map(value => value),
        natGatewayId.map(value => value),
        transitGatewayId.map(value => value),
        localGatewayId.map(value => value),
        carrierGatewayId.map(value => value),
        networkInterfaceId.map(value => value),
        routeTableId,
        vpcPeeringConnectionId.map(value => value),
        coreNetworkArn.map(value => value)
      )
    def destinationCidrBlock: Optional[String]
    def destinationIpv6CidrBlock: Optional[String]
    def destinationPrefixListId: Optional[PrefixListResourceId]
    def dryRun: Optional[Boolean]
    def vpcEndpointId: Optional[VpcEndpointId]
    def egressOnlyInternetGatewayId: Optional[EgressOnlyInternetGatewayId]
    def gatewayId: Optional[RouteGatewayId]
    def instanceId: Optional[InstanceId]
    def localTarget: Optional[Boolean]
    def natGatewayId: Optional[NatGatewayId]
    def transitGatewayId: Optional[TransitGatewayId]
    def localGatewayId: Optional[LocalGatewayId]
    def carrierGatewayId: Optional[CarrierGatewayId]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def routeTableId: RouteTableId
    def vpcPeeringConnectionId: Optional[VpcPeeringConnectionId]
    def coreNetworkArn: Optional[CoreNetworkArn]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationIpv6CidrBlock: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationIpv6CidrBlock", destinationIpv6CidrBlock)
    def getDestinationPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField(
        "destinationPrefixListId",
        destinationPrefixListId
      )
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getEgressOnlyInternetGatewayId
        : ZIO[Any, AwsError, EgressOnlyInternetGatewayId] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getGatewayId: ZIO[Any, AwsError, RouteGatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getLocalTarget: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("localTarget", localTarget)
    def getNatGatewayId: ZIO[Any, AwsError, NatGatewayId] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getLocalGatewayId: ZIO[Any, AwsError, LocalGatewayId] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getCarrierGatewayId: ZIO[Any, AwsError, CarrierGatewayId] =
      AwsError.unwrapOptionField("carrierGatewayId", carrierGatewayId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, VpcPeeringConnectionId] =
      AwsError.unwrapOptionField(
        "vpcPeeringConnectionId",
        vpcPeeringConnectionId
      )
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest
  ) extends zio.aws.ec2.model.ReplaceRouteRequest.ReadOnly {
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val destinationIpv6CidrBlock: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationIpv6CidrBlock())
        .map(value => value: String)
    override val destinationPrefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val vpcEndpointId: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => zio.aws.ec2.model.primitives.VpcEndpointId(value))
    override val egressOnlyInternetGatewayId
        : Optional[EgressOnlyInternetGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.egressOnlyInternetGatewayId())
      .map(value =>
        zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId(value)
      )
    override val gatewayId: Optional[RouteGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => zio.aws.ec2.model.primitives.RouteGatewayId(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val localTarget: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.localTarget())
      .map(value => value: Boolean)
    override val natGatewayId: Optional[NatGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.natGatewayId())
      .map(value => zio.aws.ec2.model.primitives.NatGatewayId(value))
    override val transitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val localGatewayId: Optional[LocalGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayId())
        .map(value => zio.aws.ec2.model.primitives.LocalGatewayId(value))
    override val carrierGatewayId: Optional[CarrierGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.carrierGatewayId())
        .map(value => zio.aws.ec2.model.primitives.CarrierGatewayId(value))
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
    override val vpcPeeringConnectionId: Optional[VpcPeeringConnectionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value =>
          zio.aws.ec2.model.primitives.VpcPeeringConnectionId(value)
        )
    override val coreNetworkArn: Optional[CoreNetworkArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkArn())
        .map(value => zio.aws.ec2.model.primitives.CoreNetworkArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest
  ): zio.aws.ec2.model.ReplaceRouteRequest.ReadOnly = new Wrapper(impl)
}
