package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterInstanceEventNotificationAttributesRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceTagAttribute: zio.aws.ec2.model.RegisterInstanceTagAttributeRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest = {
    import RegisterInstanceEventNotificationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceTagAttribute(instanceTagAttribute.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly =
    zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest
      .wrap(buildAwsValue())
}
object RegisterInstanceEventNotificationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest =
      zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest(
        dryRun.map(value => value),
        instanceTagAttribute.asEditable
      )
    def dryRun: Optional[Boolean]
    def instanceTagAttribute
        : zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceTagAttribute: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly
    ] = ZIO.succeed(instanceTagAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ) extends zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceTagAttribute
        : zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly =
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest
        .wrap(impl.instanceTagAttribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ): zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
