package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RebootInstancesRequest(
    instanceIds: Iterable[InstanceId],
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RebootInstancesRequest = {
    import RebootInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RebootInstancesRequest
      .builder()
      .instanceIds(instanceIds.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RebootInstancesRequest.ReadOnly =
    zio.aws.ec2.model.RebootInstancesRequest.wrap(buildAwsValue())
}
object RebootInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RebootInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RebootInstancesRequest = zio.aws.ec2.model
      .RebootInstancesRequest(instanceIds, dryRun.map(value => value))
    def instanceIds: List[InstanceId]
    def dryRun: Optional[Boolean]
    def getInstanceIds: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instanceIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RebootInstancesRequest
  ) extends zio.aws.ec2.model.RebootInstancesRequest.ReadOnly {
    override val instanceIds: List[InstanceId] = impl
      .instanceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.InstanceId(item)
      }
      .toList
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RebootInstancesRequest
  ): zio.aws.ec2.model.RebootInstancesRequest.ReadOnly = new Wrapper(impl)
}
