package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PricingDetail(
    count: Optional[Integer] = Optional.Absent,
    price: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PricingDetail = {
    import PricingDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PricingDetail
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(price.map(value => value: java.lang.Double))(_.price)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PricingDetail.ReadOnly =
    zio.aws.ec2.model.PricingDetail.wrap(buildAwsValue())
}
object PricingDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PricingDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PricingDetail = zio.aws.ec2.model
      .PricingDetail(count.map(value => value), price.map(value => value))
    def count: Optional[Integer]
    def price: Optional[Double]
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("price", price)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PricingDetail
  ) extends zio.aws.ec2.model.PricingDetail.ReadOnly {
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val price: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.price())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PricingDetail
  ): zio.aws.ec2.model.PricingDetail.ReadOnly = new Wrapper(impl)
}
