package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NitroTpmSupport {
  def unwrap: software.amazon.awssdk.services.ec2.model.NitroTpmSupport
}
object NitroTpmSupport {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NitroTpmSupport
  ): zio.aws.ec2.model.NitroTpmSupport = value match {
    case software.amazon.awssdk.services.ec2.model.NitroTpmSupport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NitroTpmSupport.UNSUPPORTED =>
      val r = unsupported
      r
    case software.amazon.awssdk.services.ec2.model.NitroTpmSupport.SUPPORTED =>
      val r = supported
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.NitroTpmSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NitroTpmSupport =
      software.amazon.awssdk.services.ec2.model.NitroTpmSupport.UNKNOWN_TO_SDK_VERSION
  }
  case object unsupported extends zio.aws.ec2.model.NitroTpmSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NitroTpmSupport =
      software.amazon.awssdk.services.ec2.model.NitroTpmSupport.UNSUPPORTED
  }
  case object supported extends zio.aws.ec2.model.NitroTpmSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NitroTpmSupport =
      software.amazon.awssdk.services.ec2.model.NitroTpmSupport.SUPPORTED
  }
}
