package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NitroEnclavesSupport {
  def unwrap: software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport
}
object NitroEnclavesSupport {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport
  ): zio.aws.ec2.model.NitroEnclavesSupport = value match {
    case software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport.UNSUPPORTED =>
      val r = unsupported
      r
    case software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport.SUPPORTED =>
      val r = supported
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.NitroEnclavesSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport =
      software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport.UNKNOWN_TO_SDK_VERSION
  }
  case object unsupported extends zio.aws.ec2.model.NitroEnclavesSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport =
      software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport.UNSUPPORTED
  }
  case object supported extends zio.aws.ec2.model.NitroEnclavesSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport =
      software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport.SUPPORTED
  }
}
