package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Monitoring(
    state: Optional[zio.aws.ec2.model.MonitoringState] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Monitoring = {
    import Monitoring.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Monitoring
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Monitoring.ReadOnly =
    zio.aws.ec2.model.Monitoring.wrap(buildAwsValue())
}
object Monitoring {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Monitoring] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Monitoring =
      zio.aws.ec2.model.Monitoring(state.map(value => value))
    def state: Optional[zio.aws.ec2.model.MonitoringState]
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.MonitoringState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Monitoring
  ) extends zio.aws.ec2.model.Monitoring.ReadOnly {
    override val state: Optional[zio.aws.ec2.model.MonitoringState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.MonitoringState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Monitoring
  ): zio.aws.ec2.model.Monitoring.ReadOnly = new Wrapper(impl)
}
